import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Vector;

public class ItemDetailPanel extends InsetPanel implements DataChangeListener {

    public ItemDetailPanel(Frame parent) {
        super(new Insets(10, 10, 10, 10));
        layout = new GridBagLayout();
        constraint = new GridBagConstraints();
        modified = false;
        views = new Vector();
        ammoComponents = new Vector();
        attachmentComponents = new Vector();
        moneyComponents = new Vector();
        itemPctViews = new NumberView[6];
        attachmentIdViews = new ChoiceView[4];
        attachmentPctViews = new NumberView[4];
        mixin = new DataChangeMixin();
        this.parent = parent;
        setLayout(layout);
        constraint.anchor = 16;
        constraint.fill = 0;
        constraint.gridx = 0;
        constraint.gridheight = 1;
        constraint.gridwidth = 1;
        constraint.insets = new Insets(0, 0, 0, 0);
        newRow();
        addText(1, "Item");
        idView = addItemView(6, "Item ID", ItemExemplar.nameList);
        newRow();
        addText(1, "Anzahl der Items");
        quantityView = addByteView(1, "Quantity");
        newRow();
        itemPctLabel = addText(1, "Item %");
        for (int idx = 0; idx < 6; idx++) {
            itemPctViews[idx] = addByteView(1, "Item " + (idx + 1) + " %");
        }

        newRow();
        ammoIdLabel = addText(1, "Munition");
        ammoComponents.addElement(ammoIdLabel);
        ammoIdView = addItemView(6, "Ammo ID", ItemExemplar.ammoNameList);
        ammoComponents.addElement(ammoIdView);
        newRow();
        ammoQuantityLabel = addText(1, "Kugelzahl");
        ammoComponents.addElement(ammoQuantityLabel);
        ammoQuantityView = addByteView(1, "Ammo Quantity");
        ammoComponents.addElement(ammoQuantityView);
        newRow();
        ammoVarietyLabel = addText(1, "Munition Variett");
        ammoComponents.addElement(ammoVarietyLabel);
        ammoVarietyView = addByteView(1, "Ammo Variety");
        ammoComponents.addElement(ammoVarietyView);
        newRow();
        ammoPctLabel = addText(1, "Munitionszustand %");
        ammoComponents.addElement(ammoPctLabel);
        ammoPctView = addByteView(1, "Ammo %");
        ammoComponents.addElement(ammoPctView);
        for (int idx = 0; idx < 4; idx++) {
            String str = "Erweiterung " + (idx + 1);
            String str2 = "Attachment " + (idx + 1);
            newRow();
            Label label = addText(1, str);
            attachmentComponents.addElement(label);
            ChoiceView view = addItemView(6, str2 + " ID", ItemExemplar.attachmentNameList);
            attachmentIdViews[idx] = view;
            attachmentComponents.addElement(view);
            NumberView pctView = addByteView(1, str2 + " %");
            attachmentPctViews[idx] = pctView;
            attachmentComponents.addElement(pctView);
            Label pctLabel = addText(1, "%");
            attachmentComponents.addElement(pctLabel);
        }

        newRow();
        addText(1, "Gewicht (x 0.1 kg)");
        weightView = addByteView(1, "Weight");
        newRow();
        moneyValueLabel = addText(1, "Geldwert");
        moneyComponents.addElement(moneyValueLabel);
        moneyValueView = addShortView(2, "Money Value");
        moneyComponents.addElement(moneyValueView);
        newRow();
        constraint.fill = 1;
        constraint.weightx = 1.0D;
        constraint.weighty = 1.0D;
        addComponent(0, new Label());
    }

    public NumberView addByteView(int colwidth, String statField) {
        return addNumberView(1, statField, 3);
    }

    private void addComponent(int colwidth, Component component) {
        constraint.gridwidth = colwidth;
        add(component, constraint);
        constraint.gridx += colwidth;
    }

    public void addDataChangeListener(DataChangeListener l) {
        mixin.addDataChangeListener(l);
    }

    public ChoiceView addItemView(int colwidth, String statField,
                                  Vector statChoices) {
        ChoiceView view = new ChoiceView(statField, statChoices);
        constraint.fill = 2;
        addComponent(colwidth, view);
        views.addElement(view);
        view.addDataChangeListener(this);
        return view;
    }

    private NumberView addNumberView(int colwidth, String statField,
                                     int charWidth) {
        NumberView view = new NumberView(statField, charWidth);
        constraint.fill = 0;
        addComponent(colwidth, view);
        views.addElement(view);
        view.addDataChangeListener(this);
        return view;
    }

    public NumberView addShortView(int colwidth, String statField) {
        return addNumberView(1, statField, 3);
    }

    private Label addText(int colwidth, String text) {
        return addText(colwidth, text, 0);
    }

    private Label addText(int colwidth, String text, int align) {
        Label label = new Label(text, align);
        constraint.fill = 2;
        addComponent(colwidth, label);
        return label;
    }

    public void dataChanged(DataChangeEvent event) {
        FieldView view = (FieldView) event.getSource();
        String oldValue = event.getOldValue();
        String newValue = event.getNewValue();
        if (item == null) {
            return;
        }
        if (view == idView) {
            if (oldValue == null || oldValue == "") {
                oldValue = ItemView.none;
            }
            if (newValue == null || newValue == "") {
                newValue = ItemView.none;
            }
            if (oldValue.equals(ItemView.none) &&
                !newValue.equals(ItemView.none)) {
                quantityView.setText("1");
                itemPctViews[0].setEnabled(true);
                itemPctViews[0].setText("100");
            } else
            if (newValue.equals(ItemView.none)) {
                quantityView.setText("0");
                itemPctViews[0].setEnabled(true);
                itemPctViews[0].setText("0");
            }
            ItemExemplar exemplar = item.getExemplar();
            if (exemplar.category == 1) {
                quantityView.setText("1");
            } else
            if (exemplar.category == 4) {
                int quantity = item.getInt("Quantity");
                for (int idx = 0; idx < quantity; idx++) {
                    itemPctViews[idx].setEnabled(true);
                    itemPctViews[idx].setText(String.valueOf(exemplar.
                            ammoCapacity));
                }

            }
            setEnabledAll();
        } else
        if (view == ammoIdView) {
            if (oldValue == null || oldValue == "") {
                oldValue = ItemView.none;
            }
            if (newValue == null || newValue == "") {
                newValue = ItemView.none;
            }
            if (!newValue.equals(ItemView.none) && !newValue.equals(oldValue)) {
                int ammoId = item.getInt("Ammo ID");
                ItemExemplar exemplar = (ItemExemplar) ItemExemplar.
                                        exemplarTable.get(new Integer(ammoId));
                System.err.println(String.valueOf(exemplar.ammoVariety));
                ammoVarietyView.setText(String.valueOf(exemplar.ammoVariety));
                ammoQuantityView.setText(String.valueOf(exemplar.ammoCapacity));
                ammoPctView.setText("100");
            }
        } else
        if (view == quantityView) {
            setEnabledAll();
        } else {
            for (int idx = 0; idx < attachmentIdViews.length; idx++) {
                if (view != attachmentIdViews[idx]) {
                    continue;
                }
                if (oldValue == null || oldValue == "") {
                    oldValue = ItemView.none;
                }
                if (newValue == null || newValue == "") {
                    newValue = ItemView.none;
                }
                if (oldValue.equals(ItemView.none) &&
                    !newValue.equals(ItemView.none)) {
                    attachmentPctViews[idx].setText("100");
                }
                break;
            }

        }
        modified = true;
        fireDataChangeEvent(event);
    }

    public void fireDataChangeEvent(DataChangeEvent e) {
        mixin.fireDataChangeEvent(e);
    }

    public boolean isModified() {
        return modified;
    }

    private void newRow() {
        constraint.gridy++;
        constraint.gridx = 0;
    }

    public void removeDataChangeListener(DataChangeListener l) {
        mixin.removeDataChangeListener(l);
    }

    public void setEnabled(Vector views, boolean enabled) {
        Component view;
        for (Enumeration e = views.elements(); e.hasMoreElements();
                             view.setEnabled(enabled)) {
            view = (Component) e.nextElement();
        }

    }

    public void setEnabledAll() {
        if (item == null) {
            return;
        }
        ItemExemplar exemplar = item.getExemplar();
        switch (exemplar.category) {
        case 1: // '\001'
            setEnabled(ammoComponents, true);
            setEnabled(attachmentComponents, true);
            setEnabled(moneyComponents, false);
            break;

        case 9: // '\t'
            setEnabled(ammoComponents, false);
            setEnabled(attachmentComponents, true);
            setEnabled(moneyComponents, false);
            break;

        case 18: // '\022'
            setEnabled(ammoComponents, false);
            setEnabled(attachmentComponents, false);
            setEnabled(moneyComponents, true);
            break;

        default:
            setEnabled(ammoComponents, false);
            setEnabled(attachmentComponents, false);
            setEnabled(moneyComponents, false);
            break;
        }
        int quantity = item.getInt("Quantity");
        for (int idx = 0; idx < 6; idx++) {
            itemPctViews[idx].setEnabled(idx < quantity);
        }

        if (quantity == 0) {
            itemPctLabel.setEnabled(false);
        } else {
            itemPctLabel.setEnabled(true);
        }
        if (exemplar.category == 4) {
            itemPctLabel.setText("Number of Rounds");
        } else {
            itemPctLabel.setText("Item %");
        }
    }

    public void setItem(Item item) {
        this.item = item;
        FieldView view;
        for (Enumeration e = views.elements(); e.hasMoreElements();
                             view.refresh()) {
            view = (FieldView) e.nextElement();
            view.setStruct(item);
        }

        setEnabledAll();
        modified = false;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }


    private GridBagLayout layout;
    private Frame parent;
    private GridBagConstraints constraint;
    private boolean modified;
    private Item item;
    private Vector views;
    private Vector ammoComponents;
    private Vector attachmentComponents;
    private Vector moneyComponents;
    private ChoiceView idView;
    private NumberView quantityView;
    private Label itemPctLabel;
    private NumberView itemPctViews[];
    private Label ammoIdLabel;
    private ChoiceView ammoIdView;
    private Label ammoQuantityLabel;
    private NumberView ammoQuantityView;
    private Label ammoVarietyLabel;
    private NumberView ammoVarietyView;
    private Label ammoPctLabel;
    private NumberView ammoPctView;
    private ChoiceView attachmentIdViews[];
    private NumberView attachmentPctViews[];
    private Label moneyValueLabel;
    private NumberView moneyValueView;
    private DataChangeMixin mixin;
    private NumberView weightView;
    static final long serialVersionUID = 030265;
}
